/*
On Air Indicator by Glen Popiel - KW5GP 


 This program is free software: you can redistribute it and/or modify
 it under the terms of the version 3 GNU General Public License as
 published by the Free Software Foundation.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 

 */

#define Signal_Threshold 100  // The signal strength required to turn on
#define Signal_Pin A0    // select the input pin for the RF sensor
#define relay 2  // The Relay control pin
#define LED 3  // The LED pin
#define hold_time 2000  // Hold for 2 seconds after signal input goes away

int Signal_Strength = 0;  // variable to store the value coming from the sensor
unsigned long timeout = 0;  // variable to store the timeout time
bool on_air = false;

void setup() 
{
  pinMode(relay, OUTPUT);  // set the relay control pin
  pinMode(LED, OUTPUT);  // set the LED pin
  digitalWrite(relay, LOW);  // Turn off the relay and LCD
  digitalWrite(LED, LOW);
}

void loop() 
{
  // read the value from the sensor:
  Signal_Strength = analogRead(Signal_Pin); // Read the Signal Strength from the RF Sensor
  if (Signal_Strength >= Signal_Threshold)  // Turn on relay and LED if threshold is exceeded
  {
    digitalWrite(relay, HIGH);
    digitalWrite(LED, HIGH);
    timeout = millis() + hold_time;  // set the timeout time
    on_air = true;
  } 
  if (millis() > timeout && on_air)  // If we've passed the timeout time, turn off the relay and LED
  {
    digitalWrite(relay, LOW);
    digitalWrite(LED, LOW);
    on_air = false;
  }
  delay(100);  // Delay 100ms to allow A/D to settle
}


